
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="wraps", lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="bowls", lb=0, ub=gurobi.GRB.INFINITY)

    # Set the objective function
    model.setObjective(5 * x1 + 7 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(3 * x1 + 5 * x2 <= 800, name="rice_constraint")
    model.addConstr(2 * x1 + 3 * x2 <= 700, name="fish_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of wraps to sell: {x1.varValue}")
        print(f"Number of bowls to sell: {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
