
import gurobipy as gp

# Create a new model
m = gp.Model("food_truck")

# Create variables
tacos = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="tacos")
burritos = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="burritos")

# Set objective function
m.setObjective(3 * tacos + 6 * burritos, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(tacos >= 50, "min_tacos")
m.addConstr(burritos >= 30, "min_burritos")
m.addConstr(tacos <= 80, "max_tacos")
m.addConstr(burritos <= 50, "max_burritos")
m.addConstr(tacos + burritos <= 100, "max_total")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of tacos: {tacos.x}")
    print(f"Number of burritos: {burritos.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

