
from gurobipy import *

# Create a new model
m = Model("FoodTruckProfit")

# Define variables
x1 = m.addVar(lb=50, ub=80, vtype=GRB.INTEGER, name="tacos")
x2 = m.addVar(lb=30, ub=50, vtype=GRB.INTEGER, name="burritos")

# Set the objective function
m.setObjective(3*x1 + 6*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 100, "total_items_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of tacos: {x1.x}")
    print(f"Number of burritos: {x2.x}")
    print(f"Total profit: {m.objVal}")
else:
    print("No optimal solution found")
