
import gurobipy as gp

def solve_food_truck_problem():
    # Create a new model
    model = gp.Model("food_truck")

    # Define variables
    x1 = model.addVar(name="tacos", lb=0, ub=100, vtype=gp.GRB.INTEGER)
    x2 = model.addVar(name="burritos", lb=0, ub=100, vtype=gp.GRB.INTEGER)

    # Objective function: Maximize profit
    model.setObjective(3*x1 + 6*x2, gp.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 >= 50, name="min_tacos")
    model.addConstr(x2 >= 30, name="min_burritos")
    model.addConstr(x1 <= 80, name="max_tacos")
    model.addConstr(x2 <= 50, name="max_burritos")
    model.addConstr(x1 + x2 <= 100, name="total_items")

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gp.GRB.OPTIMAL:
        print(f"Optimal solution: tacos = {x1.varValue}, burritos = {x2.varValue}")
        print(f"Max profit: ${3*x1.varValue + 6*x2.varValue}")
    else:
        print("No optimal solution found.")

solve_food_truck_problem()
