
import gurobipy as gp

# Create a new model
m = gp.Model("Landscaping")

# Create variables
x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # number of type A layouts
x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2") # number of type B layouts
x3 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x3") # number of type C layouts


# Set objective function
m.setObjective(200*x1 + 175*x2 + 225*x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x1 + 5*x2 + 12*x3 <= 1200, "Rock")
m.addConstr(7*x1 + 12*x2 + 4*x3 <= 700, "Mulch")
m.addConstr(15*x1 + 10*x2 + 12*x3 <= 2000, "Grass")
m.addConstr(x1 >= 0)
m.addConstr(x2 >= 0)
m.addConstr(x3 >= 0)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of Type A layouts: {x1.x}")
    print(f"Number of Type B layouts: {x2.x}")
    print(f"Number of Type C layouts: {x3.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

