
import gurobipy as gp

# Create a new model
model = gp.Model("Landscaper_Problem")

# Define variables
x1 = model.addVar(name="Type_A", lb=0, vtype=gp.GRB.INTEGER)  # Type A layout
x2 = model.addVar(name="Type_B", lb=0, vtype=gp.GRB.INTEGER)  # Type B layout
x3 = model.addVar(name="Type_C", lb=0, vtype=gp.GRB.INTEGER)  # Type C layout

# Define objective function
model.setObjective(200*x1 + 175*x2 + 225*x3, gp.GRB.MAXIMIZE)

# Define constraints
model.addConstr(10*x1 + 5*x2 + 12*x3 <= 1200, name="Rock_Constraint")
model.addConstr(7*x1 + 12*x2 + 4*x3 <= 700, name="Mulch_Constraint")
model.addConstr(15*x1 + 10*x2 + 12*x3 <= 2000, name="Grass_Constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Type A layout: {x1.varValue}")
    print(f"Type B layout: {x2.varValue}")
    print(f"Type C layout: {x3.varValue}")
    print(f"Max Profit: {model.objVal}")
else:
    print("The model is infeasible or unbounded.")
