
import gurobipy as gp

# Create a new model
model = gp.Model("Vehicle Production")

# Create decision variables
cars = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cars")
bikes = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bikes")


# Set objective function
model.setObjective(5000 * cars + 1000 * bikes, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(3 * cars + 1 * bikes <= 400, "Engineering Time")
model.addConstr(30 * cars + 30 * bikes <= 1000, "Steel")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Cars to Produce: {cars.x}")
    print(f"Number of Bikes to Produce: {bikes.x}")
    print(f"Optimal Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

