
from gurobipy import *

# Create a new model
m = Model("Vehicle_Production")

# Define variables
x1 = m.addVar(lb=0, name="cars")
x2 = m.addVar(lb=0, name="bikes")

# Set objective function
m.setObjective(5000*x1 + 1000*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 100/3, "steel_constraint")
m.addConstr(3*x1 + x2 <= 400, "engineering_time_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Cars: {x1.x}")
    print(f"Bikes: {x2.x}")
    print(f"Maximum Profit: ${m.objVal}")
else:
    print("No optimal solution found")
