
import gurobipy as gp

# Create a new model
model = gp.Model("Vehicle_Production")

# Define the variables
x1 = model.addVar(name="cars", lb=0)  # Number of cars
x2 = model.addVar(name="bikes", lb=0)  # Number of bikes

# Define the objective function
model.setObjective(5000*x1 + 1000*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(30*x1 + 30*x2 <= 1000, name="steel_constraint")
model.addConstr(3*x1 + x2 <= 400, name="engineering_time_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Cars to produce: {x1.varValue}")
    print(f"Bikes to produce: {x2.varValue}")
    print(f"Max Profit: {model.objVal}")
else:
    print("No optimal solution found.")
