
import gurobipy as gp

# Create a new model
m = gp.Model("fast_food_optimization")

# Create variables
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cheeseburgers")
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fries")


# Set objective function
m.setObjective(1.5 * x1 + x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 110, "cheeseburger_demand")
m.addConstr(x2 <= 80, "fries_demand")
m.addConstr(x1 + x2 <= 150, "total_capacity")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of cheeseburgers: {x1.x}")
    print(f"Number of fries: {x2.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

