
from gurobipy import *

# Create a model
m = Model("Fast_Food_Optimization")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cheeseburgers")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="fries")

# Set the objective function
m.setObjective(1.50*x1 + 1*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 110, "daily_demand_cheeseburgers")
m.addConstr(x2 <= 80, "daily_demand_fries")
m.addConstr(x1 + x2 <= 150, "total_capacity")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Cheeseburgers to produce: {x1.x}")
    print(f"Fries to produce: {x2.x}")
    print(f"Maximum profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
