
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, name="cheeseburgers")
    x2 = model.addVar(lb=0, name="fries")

    # Objective function: maximize 1.50*x1 + 1*x2
    model.setObjective(1.50 * x1 + 1 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 <= 110, name="cheeseburger_demand")
    model.addConstr(x2 <= 80, name="fries_demand")
    model.addConstr(x1 + x2 <= 150, name="capacity")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Cheeseburgers: {x1.varValue}")
        print(f"Fries: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
