
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("furniture_optimization")

# Create variables
sofas = m.addVar(lb=0, vtype=GRB.INTEGER, name="sofas")
beds = m.addVar(lb=0, vtype=GRB.INTEGER, name="beds")

# Set objective function
m.setObjective(100 * sofas + 200 * beds, GRB.MAXIMIZE)

# Add constraints
m.addConstr(8 * sofas + 12 * beds <= 500, "space_constraint")
m.addConstr(200 * sofas + 300 * beds <= 12500, "budget_constraint")
m.addConstr(sofas >= 0.3 * (sofas + beds), "sofa_proportion_constraint")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Sofas: {sofas.x}")
    print(f"Number of Beds: {beds.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

