
import gurobipy as gp

# Create a new model
m = gp.Model("Sofa_Bed_Optimization")

# Define the variables
x1 = m.addVar(name="sofas", vtype=gp.GRB.INTEGER, lb=0)
x2 = m.addVar(name="beds", vtype=gp.GRB.INTEGER, lb=0)

# Objective function: Maximize profit
m.setObjective(100*x1 + 200*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(8*x1 + 12*x2 <= 500, name="space_constraint")
m.addConstr(200*x1 + 300*x2 <= 12500, name="budget_constraint")
m.addConstr(0.7*x1 - 0.3*x2 >= 0, name="sofa_percentage_constraint")

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of sofas: {x1.varValue}")
    print(f"Number of beds: {x2.varValue}")
    print(f"Max profit: {m.objVal}")
else:
    print("No optimal solution found.")
