
import gurobipy as gp

# Create a new model
m = gp.Model("Investment_Problem")

# Create variables
x1 = m.addVar(lb=0, name="investment_younger_sister")
x2 = m.addVar(lb=0, name="investment_elder_sister")

# Set objective function
m.setObjective(0.05 * x1 + 0.08 * x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 5000, "total_investment")
m.addConstr(x1 >= 0.4 * (x1 + x2), "min_investment_younger_sister")
m.addConstr(x2 >= 2000, "min_investment_elder_sister")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal investment in younger sister's company: ${x1.x}")
    print(f"Optimal investment in elder sister's company: ${x2.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

