
from gurobipy import *

# Create a new model
m = Model("Investment_Problem")

# Define variables
x1 = m.addVar(lb=0, name="amount_in_younger_sister_company")
x2 = m.addVar(lb=0, name="amount_in_elder_sister_company")

# Set the objective function
m.setObjective(0.05*x1 + 0.08*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 5000, "total_investment")
m.addConstr(x1 >= 0.4*(x1 + x2), "minimum_younger_sister_investment")
m.addConstr(x2 >= 2000, "minimum_elder_sister_investment")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal investment in younger sister's company: {x1.x}")
    print(f"Optimal investment in elder sister's company: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("Model is not optimal")
