
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="younger_sister_company", lb=0)
    x2 = model.addVar(name="elder_sister_company", lb=0)

    # Objective function
    model.setObjective(0.05 * x1 + 0.08 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 5000, name="total_investment")
    model.addConstr(x1 >= 0.4 * (x1 + x2), name="min_younger_sister")
    model.addConstr(x2 >= 2000, name="min_elder_sister")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal investment in younger sister's company: ", x1.varValue)
        print("Optimal investment in elder sister's company: ", x2.varValue)
        print("Max Profit: ", model.objVal)
    else:
        print("No optimal solution found")

solve_investment_problem()
