
import gurobipy as gp

# Create a new model
m = gp.Model("IND Foods Production")

# Create variables
x1 = m.addVar(name="basmati_rice", lb=0)  # Kilograms of basmati rice
x2 = m.addVar(name="bananas", lb=0)  # Kilograms of bananas


# Set objective function
m.setObjective(15*x1 + 28*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1.5*x1 + 2*x2 <= 90, "human_labor")
m.addConstr(2*x1 + 4*x2 <= 150, "machine_labor")
m.addConstr(3*x1 + 1.5*x2 <= 70, "sun_time")


# Optimize model
m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found. Maximum profit: ${m.objVal:.2f}")
    print(f"Kilograms of basmati rice to produce: {x1.x:.2f}")
    print(f"Kilograms of bananas to produce: {x2.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status {m.status}")

