
from gurobipy import *

# Create a new model
m = Model("IND_Foods")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="basmati_rice")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bananas")

# Set objective function
m.setObjective(15*x1 + 28*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(1.5*x1 + 2*x2 <= 90, "human_labor")
m.addConstr(2*x1 + 4*x2 <= 150, "machine_work")
m.addConstr(3*x1 + 1.5*x2 <= 70, "time_under_sun")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Basmati rice: {x1.x} kg")
    print(f"Bananas: {x2.x} kg")
    print(f"Max Profit: ${m.objVal}")
else:
    print("No optimal solution found")

