
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="basmati_rice", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="bananas", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function
    model.setObjective(15 * x1 + 28 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(1.5 * x1 + 2 * x2 <= 90, name="human_labor")
    model.addConstr(2 * x1 + 4 * x2 <= 150, name="machine_work")
    model.addConstr(3 * x1 + 1.5 * x2 <= 70, name="resting_sun")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal production quantities: basmati rice = {x1.varValue} kg, bananas = {x2.varValue} kg")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("The problem is infeasible.")

solve_optimization_problem()
