
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("JewelryProduction")

# Create decision variables
rings = model.addVar(vtype=GRB.CONTINUOUS, name="rings")
necklaces = model.addVar(vtype=GRB.CONTINUOUS, name="necklaces")


# Set objective function
model.setObjective(50 * rings + 75 * necklaces, GRB.MAXIMIZE)

# Add constraints
model.addConstr(rings + 3 * necklaces <= 15, "heating_machine")
model.addConstr(2 * rings + 4 * necklaces <= 12, "polishing_machine")
model.addConstr(rings >= 0, "rings_nonnegative")  # Ensure non-negativity
model.addConstr(necklaces >= 0, "necklaces_nonnegative") # Ensure non-negativity

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${model.objVal:.2f}")
    print(f"Number of rings to produce: {rings.x:.2f}")
    print(f"Number of necklaces to produce: {necklaces.x:.2f}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

