
from gurobipy import *

# Create a new model
m = Model("Production_Optimization")

# Add variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="number_of_rings_produced", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="number_of_necklaces_produced", lb=0)

# Set the objective function
m.setObjective(50*x1 + 75*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + 3*x2 <= 15, "heating_machine_constraint")
m.addConstr(2*x1 + 4*x2 <= 12, "polishing_machine_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of rings produced: {x1.x}")
    print(f"Number of necklaces produced: {x2.x}")
    print(f"Maximum profit: ${50*x1.x + 75*x2.x:.2f}")
else:
    print("No optimal solution found.")

