
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(lb=0, name="x1")  # number of rings
x2 = model.addVar(lb=0, name="x2")  # number of necklaces

# Define the objective function
model.setObjective(50 * x1 + 75 * x2, gurobi.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(x1 + 3 * x2 <= 15, name="heating_machine")
model.addConstr(2 * x1 + 4 * x2 <= 12, name="polishing_machine")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution:")
    print(f"Number of rings: {x1.varValue}")
    print(f"Number of necklaces: {x2.varValue}")
    print(f"Max profit: {model.objVal}")
else:
    print("No optimal solution found")
