
from gurobipy import Model, GRB

# Create a new model
m = Model("sauce_production")

# Create variables
pasta = m.addVar(vtype=GRB.CONTINUOUS, name="pasta")
bbq = m.addVar(vtype=GRB.CONTINUOUS, name="bbq")

# Set objective function
m.setObjective(3 * pasta + 5 * bbq, GRB.MAXIMIZE)

# Add constraints
m.addConstr(pasta + 3 * bbq <= 12500, "filling_constraint")
m.addConstr(3 * pasta + 4 * bbq <= 20000, "jarring_constraint")
m.addConstr(pasta >= 0, "pasta_nonnegativity")
m.addConstr(bbq >= 0, "bbq_nonnegativity")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Jars of pasta sauce: {pasta.x:.2f}")
    print(f"Jars of barbecue sauce: {bbq.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

