
from gurobipy import *

# Create a new model
m = Model("sauce_factory")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="pasta_sauce", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="barbecue_sauce", lb=0)

# Set the objective function
m.setObjective(3*x1 + 5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + 3*x2 <= 12500, "filling_machine")
m.addConstr(3*x1 + 4*x2 <= 20000, "jarring_machine")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Produce {x1.x} jars of pasta sauce")
    print(f"Produce {x2.x} jars of barbecue sauce")
    print(f"Maximum profit: ${m.objVal}")
else:
    print("No optimal solution found")
