
import gurobipy as gp

# Create a new model
model = gp.Model("Sauce_Production")

# Define variables
x1 = model.addVar(name="pasta_sauce", lb=0, vtype=gp.GRB.CONTINUOUS)  # jars of pasta sauce
x2 = model.addVar(name="barbecue_sauce", lb=0, vtype=gp.GRB.CONTINUOUS)  # jars of barbecue sauce

# Objective function: Maximize profit
model.setObjective(3*x1 + 5*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 + 3*x2 <= 12500, name="filling_machine_constraint")
model.addConstr(3*x1 + 4*x2 <= 20000, name="jarring_machine_constraint")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal production levels: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum profit: ${3*x1.x + 5*x2.x:.2f}")
else:
    print("The model is infeasible or unbounded.")
