
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("e_commerce_optimization")

# Create variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="face_masks") # Number of face masks
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="hand_sanitizers") # Number of hand sanitizers


# Set objective function: Maximize profit
m.setObjective(1*x1 + 1.5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(1.5*x1 + 3*x2 <= 1000, "budget_constraint") # Budget constraint
m.addConstr(x1 >= 80, "min_face_masks") # Minimum face masks constraint
m.addConstr(x1 <= 500, "max_face_masks") # Maximum face masks constraint
m.addConstr(x2 <= 0.5*x1, "max_hand_sanitizers") # Maximum hand sanitizers constraint


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"Number of face masks: {x1.x}")
    print(f"Number of hand sanitizers: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

