
from gurobipy import *

# Create a model
m = Model("Ecommerce_Optimization")

# Define variables
x1 = m.addVar(lb=80, ub=500, vtype=GRB.INTEGER, name="face_masks")
x2 = m.addVar(lb=0, ub=250, vtype=GRB.INTEGER, name="hand_sanitizers")  # Upper bound set based on x2 <= 0.5*x1 and x1 <= 500

# Define the objective function
m.setObjective(1*x1 + 1.5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(1.5*x1 + 3*x2 <= 1000, name="budget_constraint")
m.addConstr(x2 <= 0.5*x1, name="hand_sanitizers_sales_constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of face masks: {x1.x}")
    print(f"Number of hand sanitizers: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
