
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=80, ub=500, name="face_masks")  # face masks
    x2 = model.addVar(name="hand_sanitizers")  # hand sanitizers

    # Objective function: Maximize 1*x1 + 1.5*x2
    model.setObjective(1*x1 + 1.5*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(1.5*x1 + 3*x2 <= 1000, name="budget_constraint")
    model.addConstr(x2 <= 0.5*x1, name="hand_sanitizer_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Face masks: {x1.varValue}")
        print(f"Hand sanitizers: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
