
import gurobipy as gp

# Create a new model
model = gp.Model("Surfboard_Skateboard_Production")

# Create variables
surfboards = model.addVar(vtype=gp.GRB.CONTINUOUS, name="surfboards")
skateboards = model.addVar(vtype=gp.GRB.CONTINUOUS, name="skateboards")


# Set objective function
model.setObjective(70 * surfboards + 45 * skateboards, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(5 * surfboards + 4 * skateboards <= 700, "wood_constraint")
model.addConstr(3 * surfboards + 2 * skateboards <= 320, "paint_constraint")
model.addConstr(surfboards >= 0, "surfboards_nonnegative")
model.addConstr(skateboards >= 0, "skateboards_nonnegative")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of surfboards to produce: {surfboards.x}")
    print(f"Number of skateboards to produce: {skateboards.x}")
    print(f"Maximum profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

