
from gurobipy import *

# Create a new model
m = Model("Surfboard_Skateboard_Optimization")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="surfboards")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="skateboards")

# Set the objective function
m.setObjective(70*x1 + 45*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x1 + 4*x2 <= 700, "wood_constraint")
m.addConstr(3*x1 + 2*x2 <= 320, "paint_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of surfboards: {x1.x}")
    print(f"Number of skateboards: {x2.x}")
    print(f"Maximum profit: ${70*x1.x + 45*x2.x:.2f}")
else:
    print("No optimal solution found.")
