
import gurobipy as gp

# Create a new model
model = gp.Model("Surfboard_Skateboard_Optimization")

# Define the variables
x1 = model.addVar(name="surfboards", lb=0, vtype=gp.GRB.INTEGER)
x2 = model.addVar(name="skateboards", lb=0, vtype=gp.GRB.INTEGER)

# Define the objective function
model.setObjective(70*x1 + 45*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(5*x1 + 4*x2 <= 700, name="wood_constraint")
model.addConstr(3*x1 + 2*x2 <= 320, name="paint_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal number of surfboards: {x1.varValue}")
    print(f"Optimal number of skateboards: {x2.varValue}")
    print(f"Maximum profit: ${model.objVal:.2f}")
else:
    print("The model is infeasible.")
