
import gurobipy as gp

# Create a new model
m = gp.Model("Lucas_Farming")

# Create variables
carrots = m.addVar(lb=0, name="carrots")  # Acres of carrots
onions = m.addVar(lb=0, name="onions")  # Acres of onions

# Set objective function
m.setObjective(75 * carrots + 90 * onions, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1.5 * carrots + 2 * onions <= 120, "tractor_time")
m.addConstr(2.5 * carrots + 2 * onions <= 200, "hand_picking_time")
m.addConstr(carrots + onions <= 120, "land_constraint")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Acres of Carrots: {carrots.x}")
    print(f"Acres of Onions: {onions.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

