
from gurobipy import *

# Create a new model
m = Model("Lucas_Farm")

# Create variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="acres_of_carrots")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="acres_of_onions")

# Set the objective function
m.setObjective(75*x1 + 90*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(1.5*x1 + 2*x2 <= 120, "tractor_time")
m.addConstr(2.5*x1 + 2*x2 <= 200, "hand_picking_time")
m.addConstr(x1 + x2 <= 120, "total_land")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Acres of carrots: {x1.x}")
    print(f"Acres of onions: {x2.x}")
    print(f"Maximum profit: ${75*x1.x + 90*x2.x:.2f}")
else:
    print("No optimal solution found")
