
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="carrots")
    x2 = model.addVar(lb=0, name="onions")

    # Define the objective function
    model.setObjective(75 * x1 + 90 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x1 + x2 <= 120, name="land_constraint")
    model.addConstr(1.5 * x1 + 2 * x2 <= 120, name="tractor_constraint")
    model.addConstr(2.5 * x1 + 2 * x2 <= 200, name="hand_picking_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Acres of carrots: {x1.varValue}")
        print(f"Acres of onions: {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
