
import gurobipy as gp

# Create a new model
model = gp.Model("Emma's_Shop")

# Create variables
dress = model.addVar(vtype=gp.GRB.CONTINUOUS, name="dress")  # Number of dresses
suit = model.addVar(vtype=gp.GRB.CONTINUOUS, name="suit")  # Number of suits


# Set objective function
model.setObjective(500 * dress + 800 * suit, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(2 * dress + 1 * suit <= 30, "Sewing_Machine_Constraint")
model.addConstr(4 * dress + 1 * suit <= 50, "Embroidery_Machine_Constraint")
model.addConstr(dress >= 0, "Non_Negative_Dress")
model.addConstr(suit >= 0, "Non_Negative_Suit")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of dresses to make: {dress.x}")
    print(f"Number of suits to make: {suit.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

