
from gurobipy import *

# Create a new model
model = Model("Emma's Production Problem")

# Define variables
x1 = model.addVar(vtype=GRB.CONTINUOUS, name="dresses", lb=0)
x2 = model.addVar(vtype=GRB.CONTINUOUS, name="suits", lb=0)

# Set the objective function
model.setObjective(500*x1 + 800*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(2*x1 + x2 <= 30, "sewing_machine")
model.addConstr(4*x1 + x2 <= 50, "embroidery_machine")

# Optimize the model
model.optimize()

# Print solution
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of dresses: {x1.x}")
    print(f"Number of suits: {x2.x}")
    print(f"Maximum profit: ${model.objVal}")
else:
    print("No optimal solution found")
