
import gurobipy as gp

def solve_production_problem():
    # Create a new model
    model = gp.Model("production_problem")

    # Define variables
    x1 = model.addVar(name="dresses", lb=0, vtype=gp.GRB.CONTINUOUS)
    x2 = model.addVar(name="suits", lb=0, vtype=gp.GRB.CONTINUOUS)

    # Objective function: Maximize profit
    model.setObjective(500*x1 + 800*x2, gp.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(2*x1 + x2 <= 30, name="sewing_machine_hours")
    model.addConstr(4*x1 + x2 <= 50, name="embroidery_machine_hours")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gp.GRB.OPTIMAL:
        print(f"Optimal production: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
        print(f"Max Profit: ${model.objVal:.2f}")
    else:
        print("The model is infeasible.")

solve_production_problem()
