
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("fabric_packages")

    # Create variables
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="package1") # number of package 1
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="package2") # number of package 2


    # Set objective function
    m.setObjective(50*x1 + 70*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(20*x1 + 40*x2 <= 10000, "blue_fabric")
    m.addConstr(30*x1 + 40*x2 <= 12000, "red_fabric")
    m.addConstr(x1 >= 0, "package1_nonnegative")
    m.addConstr(x2 >= 0, "package2_nonnegative")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print(f"Optimal profit: ${m.objVal:.2f}")
        print(f"Number of package 1: {x1.x:.2f}")
        print(f"Number of package 2: {x2.x:.2f}")
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
