
from gurobipy import *

# Create a new model
m = Model("Fabric_Sales")

# Define variables
x1 = m.addVar(name="Package_1", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="Package_2", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(50*x1 + 70*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x1 + 40*x2 <= 10000, name="Blue_Fabric_Constraint")
m.addConstr(30*x1 + 40*x2 <= 12000, name="Red_Fabric_Constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Package 1: {x1.x}")
    print(f"Package 2: {x2.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
