
import gurobipy as gp

# Create a new model
model = gp.Model("Fabric_Optimization")

# Define the variables
x1 = model.addVar(name="Package_1", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="Package_2", lb=0, vtype=gp.GRB.CONTINUOUS)

# Define the objective function
model.setObjective(50*x1 + 70*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(20*x1 + 40*x2 <= 10000, name="Blue_Fabric_Constraint")
model.addConstr(30*x1 + 40*x2 <= 12000, name="Red_Fabric_Constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found: Package 1 = {x1.varValue}, Package 2 = {x2.varValue}")
    print(f"Maximum profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found")
