
import gurobipy as gp

# Create a new model
m = gp.Model("Costume Production")

# Create variables
superhero = m.addVar(vtype=gp.GRB.INTEGER, name="superhero")
fantasy = m.addVar(vtype=gp.GRB.INTEGER, name="fantasy")


# Set objective function
m.setObjective(24 * superhero + 32 * fantasy, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(20 * superhero + 15 * fantasy <= 3000, "time_constraint")
m.addConstr(fantasy >= 3 * superhero, "market_constraint")
m.addConstr(superhero >=0, "non_negativity_superhero")
m.addConstr(fantasy >= 0, "non_negativity_fantasy")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Superhero Costumes: {superhero.x}")
    print(f"Number of Fantasy Costumes: {fantasy.x}")
    print(f"Total Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

