
from gurobipy import *

# Create a new model
m = Model("Costume_Production")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="superhero_costumes")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="fantasy_costumes")

# Set the objective function
m.setObjective(24*x1 + 32*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x1 + 15*x2 <= 3000, "time_constraint")
m.addConstr(x2 >= 3*x1, "market_research_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of superhero costumes: {x1.x}")
    print(f"Number of fantasy costumes: {x2.x}")
    print(f"Total profit: ${24*x1.x + 32*x2.x:.2f}")
else:
    print("No optimal solution found")
