
import gurobi

def solve_party_supplies_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="superhero_costumes", lb=0, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="fantasy_costumes", lb=0, vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(24 * x1 + 32 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(20 * x1 + 15 * x2 <= 3000, name="time_constraint")
    model.addConstr(x2 >= 3 * x1, name="ratio_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
        print(f"Maximum profit: ${24 * x1.varValue + 32 * x2.varValue}")
    else:
        print("No optimal solution found.")

solve_party_supplies_problem()
