
import gurobipy as gp

# Create a new model
m = gp.Model("investment_problem")

# Create variables
son_investment = m.addVar(name="son_investment")
friend_investment = m.addVar(name="friend_investment")

# Set objective function
m.setObjective(0.08 * son_investment + 0.10 * friend_investment, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(son_investment + friend_investment <= 50000, "total_investment")
m.addConstr(son_investment >= 3 * friend_investment, "son_friend_ratio")
m.addConstr(son_investment <= 40000, "son_investment_cap")
m.addConstr(son_investment >= 0, "son_non_negative")  # Ensure non-negativity
m.addConstr(friend_investment >= 0, "friend_non_negative") # Ensure non-negativity

# Optimize model
m.optimize()

# Check for infeasibility
if m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal solution:")
    print(f"Invest ${son_investment.x:.2f} in son's company")
    print(f"Invest ${friend_investment.x:.2f} in friend's company")
    print(f"Maximum earnings: ${m.objVal:.2f}")

