
from gurobipy import *

# Create a new model
m = Model("Investment_Optimization")

# Define variables
x1 = m.addVar(lb=0, name="son_company")
x2 = m.addVar(lb=0, name="friend_company")

# Set the objective function
m.setObjective(0.08*x1 + 0.10*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 == 50000, "total_investment")
m.addConstr(x1 >= 3*x2, "son_vs_friend")
m.addConstr(x1 <= 40000, "max_son_investment")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Amount invested in son's company: {x1.x}")
    print(f"Amount invested in friend's company: {x2.x}")
    print(f"Total earnings: {m.objVal}")
else:
    print("No optimal solution found")
