
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=0, ub=40000)  # amount invested in his son's company
    x2 = model.addVar(name="x2", lb=0)  # amount invested in his friend's company

    # Objective function: maximize 0.08*x1 + 0.10*x2
    model.setObjective(0.08*x1 + 0.10*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 50000, name="total_investment")
    model.addConstr(x1 >= 3*x2, name="son_friend_investment_ratio")
    model.addConstr(x1 <= 40000, name="son_investment_limit")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Amount invested in son's company: ${x1.varValue:.2f}")
        print(f"Amount invested in friend's company: ${x2.varValue:.2f}")
        print(f"Maximized earnings: ${0.08*x1.varValue + 0.10*x2.varValue:.2f}")
    else:
        print("No optimal solution found.")

solve_investment_problem()
