
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("maximize_profit")

# Create variables
controllers = m.addVar(lb=0, vtype=GRB.INTEGER, name="controllers")
speakers = m.addVar(lb=0, vtype=GRB.INTEGER, name="speakers")

# Set objective function
m.setObjective(70 * controllers + 20 * speakers, GRB.MAXIMIZE)

# Add constraints
m.addConstr(150 * controllers + 100 * speakers <= 50000, "budget_constraint")
m.addConstr(controllers >= 15, "min_controllers")
m.addConstr(controllers <= 60, "max_controllers")
m.addConstr(speakers <= 4 * controllers, "speaker_controller_ratio")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of controllers to sell: {controllers.x}")
    print(f"Number of speakers to sell: {speakers.x}")

