
from gurobipy import *

# Create a new model
m = Model("Iota_Game_Profit")

# Define variables
x1 = m.addVar(name="controllers", lb=0)
x2 = m.addVar(name="speakers", lb=0)

# Set objective function
m.setObjective(70*x1 + 20*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(150*x1 + 100*x2 <= 50000, name="budget")
m.addConstr(x1 >= 15, name="min_controllers")
m.addConstr(x1 <= 60, name="max_controllers")
m.addConstr(x2 <= 4*x1, name="speakers_to_controllers_ratio")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Controllers: {x1.x}")
    print(f"Speakers: {x2.x}")
    print(f"Max Profit: {m.objVal}")
else:
    print("No optimal solution found")
