
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, name="controllers") # Non-negativity assumed
    x2 = model.addVar(lb=0, name="speakers")   # Non-negativity assumed

    # Objective function
    model.setObjective(70*x1 + 20*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(150*x1 + 100*x2 <= 50000, name="budget_constraint")
    model.addConstr(x1 >= 15, name="min_controllers")
    model.addConstr(x1 <= 60, name="max_controllers")
    model.addConstr(x2 <= 4*x1, name="speakers_vs_controllers")

    # Update model
    model.update()

    # Solve model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Controllers: {x1.varValue}")
        print(f"Speakers: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
